package com.agilex.healthcare.directscheduling.domain;

import com.fasterxml.jackson.annotation.JsonProperty;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.Collection;

@XmlRootElement(name = "facilityProvider", namespace = Namespace.DirectScheduling)
@XmlAccessorType(value = XmlAccessType.NONE)
public class DirectSchedulingFacilityProvider implements Serializable {

	private static final long serialVersionUID = 4605138714812379582L;

	private String facilityId;
	private String institutionName;
	private String institutionCode;
	private Collection<FacilityMemberTeam> primaryList;
	private Collection<FacilityMemberClinic> clinicList;
	private Collection<FacilityMemberTeam> teamList;

	public DirectSchedulingFacilityProvider() {
	}

	@XmlElement(name = "facilityId")
	public String getFacilityId() {

		return facilityId;
	}

	public void setFacilityId(String facilityId) {

		this.facilityId = facilityId;
	}

	@JsonProperty("primaryProviderList")
	@XmlElement(name = "primaryProviderList")
	public Collection<FacilityMemberTeam> getPrimaryList() {

		return primaryList;
	}

	public void setPrimaryList(
			Collection<FacilityMemberTeam> primaryCareStaffList) {

		this.primaryList = primaryCareStaffList;
	}

	@XmlElement(name = "clinicList")
	public Collection<FacilityMemberClinic> getClinicList() {

		return clinicList;
	}

	public void setClinicList(Collection<FacilityMemberClinic> primaryCareClinicList) {

		this.clinicList = primaryCareClinicList;
	}

	@JsonProperty("facilityName")
	@XmlElement(name = "facilityName")
	public String getInstitutionName() {

		return institutionName;
	}

	public void setInstitutionName(String institutionName) {

		this.institutionName = institutionName;
	}
	
	@XmlElement(name = "institutionCode")
	public String getInstitutionCode() {
		return institutionCode;
	}

	public void setInstitutionCode(String institutionCode) {
		this.institutionCode = institutionCode;
	}

	@XmlElement(name = "teamList")
	public Collection<FacilityMemberTeam> getTeamList() {

		return teamList;
	}

	public void setTeamList(Collection<FacilityMemberTeam> teamList) {

		this.teamList = teamList;
	}

}
